<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>

    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Staničení a odstup podél trasy</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Staničení a odstup podél trasy</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Základní (Aktivní) trasa:</th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="HorizontalAlignment/@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" width="90%">
                                    <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Trasa Název:&#xa0;</th>
                                                <td align="left" colspan="4" valign="bottom">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Trasa Popis:&#xa0;</th>
                                                <td align="left" colspan="4">
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Trasa Styl:&#xa0;</th>
                                                <td align="left" colspan="4">
                                                    <xsl:value-of select="@style"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Point</th>
                                                <th/>
                                                <xsl:if test="not(number(StationOffsetPoints/StationOffsetPoint/@secondOffset) = 0)">
                                                    <th>Vzdálenost k</th>
                                                </xsl:if>
                                                <th/>
                                                <th colspan="3" lang="en" nowrap="nowrap">- - - - - - Definovaná trasa - - - - - -</th>
                                                <xsl:if test="not(number(StationOffsetPoints/StationOffsetPoint/@secondOffset) = 0)">
                                                    <th colspan="2" lang="en" nowrap="nowrap">- - - - Odstup bod - - - -</th>
                                                </xsl:if>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">Typ</th>
                                                <th align="right" class="underline" lang="en">Staničení</th>
                                                <xsl:if test="not(number(StationOffsetPoints/StationOffsetPoint/@secondOffset) = 0)">
                                                    <th align="right" class="underline" lang="en">Odstup Bod</th>
                                                </xsl:if>
                                                <th align="right" class="underline" lang="en">Radiální směr</th>
                                                <th align="right" class="underline" lang="en">Y<sub>s-jtsk</sub></th>
                                                <th align="right" class="underline" lang="en">X<sub>s-jtsk</sub></th>
                                                <th align="right" class="underline" lang="en">Z</th>
                                                <xsl:if test="not(number(StationOffsetPoints/StationOffsetPoint/@secondOffset) = 0)">
                                                    <th align="right" class="underline" lang="en">Y<sub>s-jtsk</sub></th>
                                                    <th align="right" class="underline" lang="en">X<sub>s-jtsk</sub></th>
                                                </xsl:if>
                                            </tr>
                                            <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                                                <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                                                    <tr>
                                                        <td colspan="6" lang="en">
                                                            <strong>
                                                                <br/>Odstup (Definovaná) trasa: &#xa0;
                                                            </strong>
                                                            <xsl:value-of select="@offsetAlignmentName"/>
                                                            <br/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="centerLinePoint/point/@type"/>
                                                    </td>
                                                    <td align="right" nowrap="nowrap">
                                                        <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <xsl:if test="not(number(@secondOffset) = 0)">
                                                        <td align="right">
                                                            <xsl:value-of select="cif:distanceFormat(number(@secondOffset))"/>
                                                        </td>
                                                    </xsl:if>
                                                    <td align="right" nowrap="nowrap">
                                                        <xsl:value-of select="cif:directionFormat(number(centerLinePoint/@radialDirection))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@easting)*(-1))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@northing)*(-1))"/>
                                                    </td>
                                                    <td align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@elevation))"/>
                                                    </td>
                                                    <xsl:if test="not(number(@secondOffset) = 0)">
                                                        <td align="right">
                                                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@easting)*(-1))"/>
                                                        </td>
                                                        <td align="right">
                                                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@northing)*(-1))"/>
                                                        </td>
                                                    </xsl:if>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body ve staničení a odstupu pomocí 
                <em> Nástroje &gt; XML Výpisy &gt; Základní staničení</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em>, v poli <em>Z</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte také vybrat nejméně jedno směrové řešení v listu <em>Směrová řešení</em> nebo prvek v listu <em>Prvky</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> (<em>
                    Směrové body - Na trase, Významné, 
					Výškové body - Na trase, Významné
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
